/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.ai;

import java.util.EnumSet;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3;
import untamedwilds.entity.ComplexMobTerrestrial;
import untamedwilds.entity.IPackEntity;

public class SmartWanderGoal
extends Goal {
    public final ComplexMobTerrestrial creature;
    protected double x;
    protected double y;
    protected double z;
    private final int runChance;
    private final int executionChance;
    private final boolean avoidWater;
    private final double speed;

    public SmartWanderGoal(ComplexMobTerrestrial entityIn, double speedIn) {
        this(entityIn, speedIn, 120, 0, false);
    }

    public SmartWanderGoal(ComplexMobTerrestrial entityIn, double speedIn, boolean avoidWater) {
        this(entityIn, speedIn, 120, 0, avoidWater);
    }

    public SmartWanderGoal(ComplexMobTerrestrial entityIn, double speedIn, int runChance, boolean avoidWater) {
        this(entityIn, speedIn, 120, runChance, avoidWater);
    }

    public SmartWanderGoal(ComplexMobTerrestrial entityIn, double speedIn, int chance, int runChance, boolean avoidWater) {
        this.creature = entityIn;
        this.speed = speedIn;
        this.executionChance = this.creature.isActive() ? chance : chance * 5;
        this.runChance = runChance;
        this.avoidWater = avoidWater;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (!this.creature.canMove() || !this.creature.m_21573_().m_26571_() || this.creature.getCommandInt() != 0 || this.creature.m_21187_().nextInt(this.executionChance) != 0) {
            return false;
        }
        Vec3 vec3d = this.getPosition();
        if (vec3d == null) {
            return false;
        }
        this.x = vec3d.f_82479_;
        this.y = vec3d.f_82480_;
        this.z = vec3d.f_82481_;
        return true;
    }

    private Vec3 getPosition() {
        if (this.creature instanceof IPackEntity && this.creature.herd != null && this.creature.herd.getLeader() != this.creature) {
            Vec3 vec3d = DefaultRandomPos.m_148403_((PathfinderMob)this.creature.herd.getLeader(), (int)7, (int)3);
            return vec3d == null ? DefaultRandomPos.m_148403_((PathfinderMob)this.creature.herd.getLeader(), (int)5, (int)2) : vec3d;
        }
        if (this.avoidWater) {
            Vec3 vec3d = DefaultRandomPos.m_148403_((PathfinderMob)this.creature, (int)15, (int)7);
            return vec3d == null ? DefaultRandomPos.m_148403_((PathfinderMob)this.creature, (int)10, (int)4) : vec3d;
        }
        return DefaultRandomPos.m_148403_((PathfinderMob)this.creature, (int)10, (int)4);
    }

    public boolean m_8045_() {
        return !this.creature.m_21573_().m_26571_();
    }

    public void m_8056_() {
        this.creature.m_21573_().m_26519_(this.x, this.y, this.z, this.speed * (double)(this.creature.m_21187_().nextInt(100) < this.runChance ? 1.8f : 1.0f));
    }
}

